import java.io.*;
import java.util.*;

public class ChromozomeParser
{
	public ChromozomeParser()
    {

    }

    public static Chromozome parseFile(String file)
    {
		Chromozome a;

		try
		{
			FileReader fileReader = new FileReader(file);
			BufferedReader bufferedReader = new BufferedReader(fileReader);

			String inputLine = bufferedReader.readLine();
			// all files should be in this format:
			// nodeSize { #,#,#,#,#, ... ,# }

			StringTokenizer st = new StringTokenizer(inputLine, ", ");
			String token = st.nextToken();
			int nodeSize = Integer.parseInt(token);

			//System.out.println("Node Size: "+nodeSize);

			// nodeSize*4 + 2 + 3
			// +2 for the start and end braces ( {} )
			// +3 for the output pointers at the end
			int totalTokens = (nodeSize*4) + 2 + 3;

			a = GeneticOperators.generateChromozome(nodeSize);

			for(int i = 0; i < totalTokens; i++)
			{
				token = st.nextToken();

				if(token.equals("{") || token.equals("}"))
				{
					// do nothing
				}
				else
				{
					a.setValueAtIndex(i-1, Integer.parseInt(token));
				}
			}

			return a;
		}
		catch (IOException e)
		{
			System.out.println("Error with I/O on chromosome");
		}


		// return null if something bad happened
		return null;

	}

}

